/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.action.ShowHelpContextAction;
import DE.siemens.ad.logo.app.comp.ControlPanelEvent;
import DE.siemens.ad.logo.app.comp.ControlPanelListener;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoHelp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ControlPanel
extends JPanel
implements ControlPanelListener {
    public static final int NOTHING = 0;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int APPLY = 4;
    public static final int HELP = 8;
    public static final int DETAILS = 16;
    public static final int CLOSE = 32;
    public static final int CLOSE_HELP = 40;
    public static final int OK_HELP = 9;
    public static final int OK_CANCEL = 3;
    public static final int OK_CLOSE = 33;
    public static final int OK_CANCEL_HELP = 11;
    public static final int APPLY_OK_CANCEL = 7;
    public static final int APPLY_OK_CANCEL_HELP = 15;
    protected Vector fControlPanelListeners;
    public SplittedDlg fSplittedDlg;
    protected int fResult = 0;
    protected Hashtable fControlButtons = new Hashtable(20);

    public ControlPanel(int mode) {
        if ((mode & 4) != 0) {
            this.add(this.createControlButton("global.apply", "Apply", 4));
        }
        if ((mode & 1) != 0) {
            this.add(this.createControlButton("global.ok", "OK", 1));
        }
        if ((mode & 2) != 0) {
            this.add(this.createControlButton("global.cancel", "Cancel", 2));
        }
        if ((mode & 0x10) != 0) {
            this.add(this.createControlButton("global.details", "Details", 16));
        }
        if ((mode & 0x20) != 0) {
            this.add(this.createControlButton("global.close", "Close", 32));
        }
        if ((mode & 8) != 0) {
            JButton button = this.createControlButton("global.help", "Help", 8);
            if (!LogoHelp.isAvailable()) {
                button.setEnabled(false);
            }
            this.add(button);
        }
    }

    public void addControlPanelListener(ControlPanelListener l) {
        if (!this.getControlPanelListeners().contains(l)) {
            this.getControlPanelListeners().add(l);
        }
    }

    public void applyPressed(ControlPanelEvent cpe) {
        DataInputPanel dataInputPanel = this.fSplittedDlg.getDataInputPanel();
        if (dataInputPanel == null) {
            return;
        }
        if (dataInputPanel.checkChanged() && dataInputPanel.checkFieldContents()) {
            dataInputPanel.storeFieldContents();
        }
    }

    public void cancelPressed(ControlPanelEvent cpe) {
        this.fSplittedDlg.close();
    }

    public void closePressed(ControlPanelEvent cpe) {
        this.fSplittedDlg.close();
    }

    public void controlPanelButtonPressed(ControlPanelEvent controlPanelEvent) {
        int buttonID;
        this.fResult = buttonID = controlPanelEvent.getButtonId();
        switch (buttonID) {
            case 1: {
                this.okPressed(controlPanelEvent);
                break;
            }
            case 2: {
                this.cancelPressed(controlPanelEvent);
                break;
            }
            case 8: {
                this.helpPressed(controlPanelEvent);
                break;
            }
            case 4: {
                this.applyPressed(controlPanelEvent);
                break;
            }
            case 16: {
                this.detailsPressed(controlPanelEvent);
                break;
            }
            case 32: {
                this.closePressed(controlPanelEvent);
                break;
            }
            default: {
                this.unknownButtonPressed(controlPanelEvent);
            }
        }
    }

    protected JButton createControlButton(String key, String defaultString, final int buttonId) {
        final JButton controlButton = new JButton();
        String buttonLabel = Language.getString(key, defaultString);
        controlButton.setText(buttonLabel);
        controlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ControlPanelEvent cpe = new ControlPanelEvent(controlButton);
                cpe.setButtonId(buttonId);
                ControlPanel.this.fireControlPanelEvent(cpe);
            }
        });
        this.fControlButtons.put(new Integer(buttonId), controlButton);
        return controlButton;
    }

    public void detailsPressed(ControlPanelEvent cpe) {
    }

    protected void fireControlPanelEvent(ControlPanelEvent cpe) {
        Vector listenerTmp = (Vector)this.getControlPanelListeners().clone();
        Enumeration e = listenerTmp.elements();
        while (e.hasMoreElements()) {
            ((ControlPanelListener)e.nextElement()).controlPanelButtonPressed(cpe);
        }
    }

    public JButton getControlButton(int buttonId) {
        return (JButton)this.fControlButtons.get(new Integer(buttonId));
    }

    public Vector getControlPanelListeners() {
        if (this.fControlPanelListeners == null) {
            this.fControlPanelListeners = new Vector();
            this.fControlPanelListeners.add(this);
        }
        return this.fControlPanelListeners;
    }

    public int getResult() {
        return this.fResult;
    }

    public void setResult(int result) {
        this.fResult = result;
    }

    public void helpPressed(ControlPanelEvent cpe) {
        String helpID = null;
        DataInputPanel dataInputPanel = this.fSplittedDlg.getDataInputPanel();
        if (dataInputPanel != null) {
            helpID = dataInputPanel.getHelpIdString();
        }
        ShowHelpContextAction action = new ShowHelpContextAction();
        action.setHelpID(helpID);
        action.setActivationWindow((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this));
        ShowHelpContextAction.setStatus(0);
        action.doIt();
    }

    public void okPressed(ControlPanelEvent cpe) {
        DataInputPanel dataInputPanel = this.fSplittedDlg.getDataInputPanel();
        if (dataInputPanel == null) {
            return;
        }
        if (!dataInputPanel.checkChanged()) {
            this.fSplittedDlg.close();
        } else if (dataInputPanel.checkFieldContents()) {
            dataInputPanel.storeFieldContents();
            this.fSplittedDlg.close();
        }
    }

    public void removeControlPanelListener(ControlPanelListener l) {
        this.getControlPanelListeners().remove(l);
    }

    public void setSplittedDlg(SplittedDlg splittedDlg) {
        this.fSplittedDlg = splittedDlg;
    }

    public void unknownButtonPressed(ControlPanelEvent cpe) {
    }
}

